#ifndef _ROUTINES_H
#define _ROUTINES_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define MAX_AUTH_LENGTH 1024 //Max size of the string used for authentication
#define MAX_KEY_LENGTH  1024 //Max size of the encryption key. (Both Registry & Generated)

#define CLIENTVER_AUTOUPDATE 0x1
#define CLIENTVER_CURRENT    0x2
#define CLIENTVER_ERROR      0x3
#define CLIENTVER_OUTDATED   0x4
#define CLIENTVER_SUPPORTED  0x5

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool WaitOnApplicationToExit(void);
bool GetRegistryValues(void);
bool SaveRegistryValues(void);
bool OpenLogFile(void);
bool CloseLogFile(void);
void WriteSysLog(char *sMessage);
void WriteLog(int iClientId, char *sMessage);
bool WaitOnApplicationToExit(void);
int CmdCmp(const char *sBuf, const char *sCmd);
int BreakCmdFromData(const char *sBuf, int iCmdLen, int iBufSz, char *sOutBuf);
int AppendDataToCmd(const char *sCmd, char *sData, int iDataSz, char *sOutBuf);
void CreateFolderStructure(char *sFullPath);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

extern char gsSessionLogDir[MAX_PATH];
extern char gsImportTempDir[MAX_PATH];
extern char gsAuthKey[MAX_AUTH_LENGTH];
extern char gsAuthString[MAX_AUTH_LENGTH];

extern char gsSQLCustDriver[255];
extern char gsSQLCustPassword[255];
extern char gsSQLCustServer[255];
extern char gsSQLCustUserID[255];

extern char gsSQLDataFiles[MAX_PATH];
extern char gsDefaultDBO[255];

extern char gsSQLIndexDatabase[255];
extern char gsSQLIndexDriver[255];
extern char gsSQLIndexPassword[255];
extern char gsSQLIndexServer[255];
extern char gsSQLIndexUserID[255];

extern int giListenPort;
extern int giMaxClients;
extern int giKeyGenLength;
extern int giRawHashLen;
extern int giHashTimeoutMS;
extern int giPingTimeoutMS;

extern int giTotalConnects;
extern int giWarningCount;
extern int giErrorCount;

extern bool gbShowSplashScreen;
extern bool gbStartAutomatically;

extern FILE *gfhSessionLog;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
